/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.common.world.gen.feature;

import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.config.YuccaTreeFeatureConfig;
import com.minecraftabnormals.atmospheric.core.other.AtmosphericTags;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;

public class YuccaTreeFeature
extends Feature<YuccaTreeFeatureConfig> {
    public YuccaTreeFeature(Codec<YuccaTreeFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, YuccaTreeFeatureConfig config) {
        if (config.baby) {
            int height = 2 + rand.nextInt(2) + rand.nextInt(2);
            boolean flag = true;
            if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.func_217301_I()) {
                for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                    int k = 1;
                    if (j == position.func_177956_o()) {
                        k = 0;
                    }
                    if (j >= position.func_177956_o() + 1 + height - 2) {
                        k = 2;
                    }
                    BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                    for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                        for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                            if (j >= 0 && j < worldIn.func_217301_I()) {
                                if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                                flag = false;
                                continue;
                            }
                            flag = false;
                        }
                    }
                }
                if (!flag) {
                    return false;
                }
                if (TreeUtil.isInTag((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), AtmosphericTags.YUCCA_PLANTABLE_ON) && position.func_177956_o() < worldIn.func_217301_I()) {
                    if (!TreeUtil.isInTag((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (ITag.INamedTag)BlockTags.field_203436_u)) {
                        TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
                    }
                    int logX = position.func_177958_n();
                    int logZ = position.func_177952_p();
                    int logY = position.func_177956_o();
                    for (int k1 = 0; k1 < height; ++k1) {
                        logY = position.func_177956_o() + k1;
                        BlockPos blockpos = new BlockPos(logX, logY, logZ);
                        if (!TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                        TreeUtil.setForcedState((IWorldWriter)worldIn, (BlockPos)blockpos, (BlockState)config.trunkProvider.func_225574_a_(rand, blockpos));
                    }
                    logY = position.func_177956_o() + height - 1;
                    position = new BlockPos(logX, logY, logZ);
                    this.createBabyYuccaLeaves((IWorldGenerationReader)worldIn, position.func_177984_a(), rand, config, false);
                    this.createBabyYuccaLeaves((IWorldGenerationReader)worldIn, position, rand, config, true);
                    this.createBabyYuccaLeaves((IWorldGenerationReader)worldIn, position.func_177977_b(), rand, config, false);
                    if (config.patch) {
                        for (int j = 0; j < 64; ++j) {
                            BlockPos blockpos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
                            if (!TreeUtil.isAir((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos) || blockpos.func_177956_o() >= 255 || !config.flowerProvider.func_225574_a_(rand, blockpos).func_196955_c((IWorldReader)worldIn, blockpos)) continue;
                            this.placeFlowerAt((IWorldGenerationReader)worldIn, blockpos, rand, config);
                        }
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        int height = 4 + rand.nextInt(2) + rand.nextInt(2);
        int reduction = 2 + rand.nextInt(3);
        if (config.petrified) {
            height -= reduction;
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.func_217301_I()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_217301_I()) {
                            if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeUtil.isInTag((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), AtmosphericTags.YUCCA_PLANTABLE_ON) && position.func_177956_o() < worldIn.func_217301_I()) {
                BlockPos blockpos;
                if (!TreeUtil.isInTag((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (ITag.INamedTag)BlockTags.field_203436_u)) {
                    TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
                }
                for (int ja = 0; ja < reduction; ++ja) {
                    if (!config.petrified) continue;
                    this.placeLogAt((IWorldWriter)worldIn, position.func_177979_c(ja), Direction.UP, false, rand, config);
                }
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                int logY = position.func_177956_o();
                for (int k1 = 0; k1 < height; ++k1) {
                    logY = position.func_177956_o() + k1;
                    BlockPos blockpos2 = new BlockPos(logX, logY, logZ);
                    if (!TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos2)) continue;
                    this.placeLogAt((IWorldWriter)worldIn, blockpos2, Direction.UP, false, rand, config);
                }
                logY = position.func_177956_o() + height - 1;
                BlockPos newPos = this.createYuccaBranch(height, (IWorldGenerationReader)worldIn, position, Direction.NORTH, rand, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos.func_177984_a(), rand, false, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos, rand, true, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos.func_177977_b(), rand, false, config);
                newPos = this.createYuccaBranch(height, (IWorldGenerationReader)worldIn, position, Direction.EAST, rand, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos.func_177984_a(), rand, false, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos, rand, true, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos.func_177977_b(), rand, false, config);
                newPos = this.createYuccaBranch(height, (IWorldGenerationReader)worldIn, position, Direction.SOUTH, rand, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos.func_177984_a(), rand, false, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos, rand, true, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos.func_177977_b(), rand, false, config);
                newPos = this.createYuccaBranch(height, (IWorldGenerationReader)worldIn, position, Direction.WEST, rand, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos.func_177984_a(), rand, false, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos, rand, true, config);
                this.createYuccaLeaves((IWorldGenerationReader)worldIn, newPos.func_177977_b(), rand, false, config);
                if (config.patch) {
                    for (int j = 0; j < 64; ++j) {
                        blockpos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
                        if (!TreeUtil.isAir((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos) || blockpos.func_177956_o() >= 255 || !config.flowerProvider.func_225574_a_(rand, blockpos).func_196955_c((IWorldReader)worldIn, blockpos)) continue;
                        this.placeFlowerAt((IWorldGenerationReader)worldIn, blockpos, rand, config);
                    }
                }
                if (config.petrified && rand.nextInt(12) == 0) {
                    for (int j = 0; j < 12; ++j) {
                        blockpos = position.func_177982_a(rand.nextInt(6) - rand.nextInt(6), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(6) - rand.nextInt(6));
                        if (!TreeUtil.isAir((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos) || blockpos.func_177956_o() >= 255 || !TreeUtil.isInTag((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177977_b(), (ITag.INamedTag)BlockTags.field_203436_u)) continue;
                        TreeUtil.setForcedState((IWorldWriter)worldIn, (BlockPos)blockpos, (BlockState)config.bundleProvider.func_225574_a_(rand, blockpos));
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void createYuccaLeaves(IWorldGenerationReader worldIn, BlockPos newPos, Random rand, boolean square, YuccaTreeFeatureConfig config) {
        int leafSize = 1;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (square) {
                    this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
                    continue;
                }
                if (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize) {
                    this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
                    continue;
                }
                if (rand.nextInt(4) != 0) continue;
                this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
            }
        }
    }

    private BlockPos createYuccaBranch(int height, IWorldGenerationReader worldIn, BlockPos pos, Direction direction, Random rand, YuccaTreeFeatureConfig config) {
        int logX = pos.func_177958_n();
        int logZ = pos.func_177952_p();
        int logY = pos.func_177956_o() + height - 1;
        int length = 4 + rand.nextInt(2);
        BlockPos blockpos = new BlockPos(logX, logY, logZ);
        boolean bundle = false;
        boolean anyBundle = false;
        for (int i = 0; i < length; ++i) {
            blockpos = new BlockPos(logX, logY, logZ);
            if (!anyBundle && rand.nextInt(16) == 0) {
                bundle = true;
                anyBundle = true;
            } else {
                bundle = false;
            }
            this.createHorizontalLog(1, worldIn, blockpos, direction, bundle, rand, config);
            if (i == length) continue;
            if (direction == Direction.EAST || direction == Direction.WEST) {
                logX = direction == Direction.EAST ? (logX += rand.nextInt(2)) : (logX -= rand.nextInt(2));
            } else {
                logZ = direction == Direction.SOUTH ? (logZ += rand.nextInt(2)) : (logZ -= rand.nextInt(2));
            }
            ++logY;
        }
        return blockpos.func_177972_a(direction);
    }

    private void createHorizontalLog(int branchLength, IWorldGenerationReader worldIn, BlockPos pos, Direction direction, boolean bundle, Random rand, YuccaTreeFeatureConfig config) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        for (int k3 = 0; k3 < branchLength; ++k3) {
            BlockPos blockpos1 = new BlockPos(logX += direction.func_82601_c(), logY, logZ += direction.func_82599_e());
            if (!TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) continue;
            if (!TreeUtil.isAir((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1.func_177977_b())) {
                bundle = false;
            }
            this.placeLogAt((IWorldWriter)worldIn, blockpos1, Direction.UP, bundle, rand, config);
        }
    }

    private void placeLogAt(IWorldWriter worldIn, BlockPos pos, Direction direction, boolean bundle, Random rand, YuccaTreeFeatureConfig config) {
        BlockState logState = config.petrified ? config.trunkProvider.func_225574_a_(rand, pos) : (BlockState)config.trunkProvider.func_225574_a_(rand, pos).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k());
        TreeUtil.setForcedState((IWorldWriter)worldIn, (BlockPos)pos, (BlockState)logState);
        if (bundle && !config.petrified) {
            TreeUtil.setForcedState((IWorldWriter)worldIn, (BlockPos)pos.func_177977_b(), (BlockState)config.branchProvider.func_225574_a_(rand, pos.func_177977_b()));
        }
    }

    private void placeLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, YuccaTreeFeatureConfig config) {
        if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)pos) && !config.petrified) {
            if (config.leavesProvider.func_225574_a_(rand, pos).func_235901_b_((Property)LeavesBlock.field_208494_a)) {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)pos, (BlockState)((BlockState)config.leavesProvider.func_225574_a_(rand, pos).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1))));
            } else {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)pos, (BlockState)config.leavesProvider.func_225574_a_(rand, pos));
            }
        }
        if (rand.nextInt(8) == 0 && !config.petrified) {
            this.placeFlowerAt(world, pos.func_177984_a(), rand, config);
        }
    }

    private void createBabyYuccaLeaves(IWorldGenerationReader worldIn, BlockPos newPos, Random rand, YuccaTreeFeatureConfig config, boolean square) {
        int leafSize = 1;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (square) {
                    this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
                    continue;
                }
                if (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize) {
                    this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
                    continue;
                }
                if (rand.nextInt(4) != 0) continue;
                this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
            }
        }
    }

    private void placeFlowerAt(IWorldGenerationReader world, BlockPos pos, Random rand, YuccaTreeFeatureConfig config) {
        if (TreeUtil.isAir((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            if (!TreeUtil.isAir((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177984_a())) {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)pos, (BlockState)config.flowerProvider.func_225574_a_(rand, pos));
            } else if (rand.nextInt(4) == 0) {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)pos, (BlockState)config.tallFlowerBottomProvider.func_225574_a_(rand, pos));
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)pos.func_177984_a(), (BlockState)config.tallFlowerTopProvider.func_225574_a_(rand, pos.func_177984_a()));
            } else {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)pos, (BlockState)config.flowerProvider.func_225574_a_(rand, pos));
            }
        }
    }
}

